/*
 *
 *  Copyright (C) 2010-2011 Amr Thabet <amr.thabet@student.alx.edu.eg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to Amr Thabet 
 *  amr.thabet@student.alx.edu.eg
 *
 */
#include "..\x86emu.h"

//this file for emulating the jmps and push &pop to stack


//PUSH & POP
int op_push(Thread& thread,ins_disasm* s){
    int dest=0;
    if (s->flags & DEST_IMM){
             if (s->hde.flags & F_IMM8 && (s->ndest & 0x80))s->ndest+=0xFFFFFF00;   
             dest=s->ndest;
    }else if (s->flags & DEST_REG){
          int dest2=thread.Exx[s->ndest];
          if (s->flags & DEST_BITS32)memcpy(&dest,&dest2,4);
          if (s->flags & DEST_BITS16)memcpy(&dest,&dest2,2);
          if (s->flags & DEST_BITS8)memcpy(&dest,&dest2,1); 
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          if (s->flags & DEST_BITS32)memcpy(&dest,ptr,4);
          if (s->flags & DEST_BITS16)memcpy(&dest,ptr,2);
          if (s->flags & DEST_BITS8)memcpy(&dest,ptr,1); 
    };
    thread.stack->push(dest);
    //cout << "src = " << dest << "\n";
};
//---------------
int op_pop(Thread& thread,ins_disasm* s){
    dword src=(dword)thread.stack->pop();
    dword dest,result;
    if (s->flags & DEST_REG){
         dest=thread.Exx[s->ndest];
          //thread.Exx[s->ndest]=src;
          if (s->flags & DEST_BITS32) memcpy(&thread.Exx[s->ndest],&src,4);
          if (s->flags & DEST_BITS16) memcpy(&thread.Exx[s->ndest],&src,2);
          if (s->flags & DEST_BITS8) memcpy(&thread.Exx[s->ndest],&src,1);
          result=thread.Exx[s->ndest];
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          dest=*ptr;
          if (s->flags & DEST_BITS32){
             dword n=src;
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)&n);
          };
          if (s->flags & DEST_BITS16){
             short n=src;
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)2,(char*)&n);
          };
          if (s->flags & DEST_BITS8){
             char n=src;   
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)1,(char*)&n);
          };
          result=*ptr;
    };
};
//----------------------------------------------------------------------------------------
//PUSHAD & POPAD
int op_pushad(Thread& thread,ins_disasm* s){
    for (int i=0;i<8;i++){
        thread.stack->push(thread.Exx[i]);
    };
};
int op_popad(Thread& thread,ins_disasm* s){
    for (int i=7;i>=0;i--){
        if (i!=4){
        thread.Exx[i]=thread.stack->pop();
        }else{
              thread.stack->pop();
        };
    };
};
//----------------------------------------------------------------------------------------
//PUSHFD & POPFD
int op_pushfd(Thread& thread,ins_disasm* s){
    thread.stack->push(thread.EFlags);
};
int op_popfd(Thread& thread,ins_disasm* s){
    thread.EFlags=thread.stack->pop();
};
//----------------------------------------------------------------------------------------
int op_enter(Thread& thread,ins_disasm* s){
    thread.stack->push(thread.Exx[5]);
        thread.Exx[5]=thread.Exx[4];
    for (int i=0;i<s->nsrc;i++){
        thread.stack->push(thread.Exx[5]);
        thread.Exx[5]=thread.Exx[4];
    };
    thread.Exx[4]-=s->ndest;
    //thread.Eip=thread.stack->pop();
}
//----------------------------------------------------------------------------------------
int op_leave(Thread& thread,ins_disasm* s){
    thread.Exx[4]=thread.Exx[5];
    dword src=(dword)thread.stack->pop();
    memcpy(&thread.Exx[5],&src,4);
    //thread.Eip=thread.stack->pop();
}
//=============================================================================================================
//JCC
int op_jcc(Thread& thread,ins_disasm* s){
    int dest=0;
    bool rel=false;
    if (s->flags & DEST_IMM){
             dest=s->ndest;
             //converting the negative imm8 to negative imm32
             if ((s->flags & DEST_BITS8) && (dest >> 7) ==1)dest+=0xFFFFFF00;
             rel=true; //that's mean that the dest will be added to or subtracted from the eip of the thread
    }else if (s->flags & DEST_REG){
           dest=thread.Exx[s->ndest];
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          memcpy(&dest,ptr,4);
    };
    //now we have the offset and now we need to chack if we will jump to it or not
    //cout <<s->opcode->substr(0,s->opcode->size()) <<"\n";
    if (s->opcode->substr(0,s->opcode->size()) =="jmp"){goto Yes_JmptoIt;
    }else if(s->opcode->substr(0,s->opcode->size()) =="ja" || s->opcode->substr(0,s->opcode->size()) =="jnbe"){
          if (!(thread.EFlags & EFLG_CF) && !(thread.EFlags & EFLG_ZF))goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="jae" || s->opcode->substr(0,s->opcode->size()) =="jnb"){
          if (!(thread.EFlags & EFLG_CF))goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="jnae" || s->opcode->substr(0,s->opcode->size()) =="jb"){
          if (thread.EFlags & EFLG_CF)goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="jbe" || s->opcode->substr(0,s->opcode->size()) =="jna"){
          if ((thread.EFlags & EFLG_CF) || (thread.EFlags & EFLG_ZF))goto Yes_JmptoIt;
           
    }else if(s->opcode->substr(0,s->opcode->size()) =="je" || s->opcode->substr(0,s->opcode->size()) =="jz"){
          if (thread.EFlags & EFLG_ZF)goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="jne" || s->opcode->substr(0,s->opcode->size()) =="jnz"){
          if (!(thread.EFlags & EFLG_ZF))goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="jnp" || s->opcode->substr(0,s->opcode->size()) =="jpo"){
          if (!(thread.EFlags & EFLG_PF))goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="jp" || s->opcode->substr(0,s->opcode->size()) =="jpe"){
          if (thread.EFlags & EFLG_PF)goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="jg" || s->opcode->substr(0,s->opcode->size()) =="jnle"){
          if (!(thread.EFlags & EFLG_SF) && !(thread.EFlags & EFLG_ZF))goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="jnge" || s->opcode->substr(0,s->opcode->size()) =="jl"){
          if (thread.EFlags & EFLG_SF)goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="jge" || s->opcode->substr(0,s->opcode->size()) =="jnl"){
          if (!(thread.EFlags & EFLG_SF))goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="jle" || s->opcode->substr(0,s->opcode->size()) =="jng"){
          if ((thread.EFlags & EFLG_SF) || (thread.EFlags & EFLG_ZF))goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="jns"){
          if (!(thread.EFlags & EFLG_SF))goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="js"){
          if (thread.EFlags & EFLG_SF)goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="jno"){
          if (!(thread.EFlags & EFLG_OF))goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="jo"){
          if (thread.EFlags & EFLG_OF)goto Yes_JmptoIt;
          
    }else if(s->hde.opcode==0xE3&& !(s->hde.flags & F_PREFIX_67)){
          if (thread.Exx[1]==0)goto Yes_JmptoIt;      
          
    }else if(s->hde.opcode==0xE3&& (s->hde.flags & F_PREFIX_67 )){
          if ((thread.Exx[1] & 0xffff)==0)goto Yes_JmptoIt;
          
    }else if(s->opcode->substr(0,s->opcode->size()) =="loop" ){
          thread.Exx[1]--;
           if (thread.Exx[1]!=0){       
              goto Yes_JmptoIt;
           };
    }else if(s->opcode->substr(0,s->opcode->size()) =="loope" || s->opcode->substr(0,s->opcode->size()) =="loopz"){
          if (thread.EFlags & EFLG_ZF && thread.Exx[1]!=0){
             thread.Exx[1]--;
             goto Yes_JmptoIt;
          };
    }else if(s->opcode->substr(0,s->opcode->size()) =="loopne" || s->opcode->substr(0,s->opcode->size()) =="loopnz"){
          if (!(thread.EFlags & EFLG_ZF) && thread.Exx[1]!=0){
             thread.Exx[1]--;
             goto Yes_JmptoIt;
          };
    };
    
    return 0;
Yes_JmptoIt:
            if (rel){
                     thread.Eip=(dword)((signed int)thread.Eip+(signed int)dest);
            }else{
                  thread.Eip=dest;//- s->hde.len;
            };
            
};
//=============================================================================================================
//CALL
int op_call(Thread& thread,ins_disasm* s){
    int dest=0;
    bool rel=false;
    if (s->flags & DEST_IMM){
             dest=s->ndest;
             rel=true; //that's mean that the dest will be added to or subtracted from the eip of the thread
    }else if (s->flags & DEST_REG){
           dest=thread.Exx[s->ndest];
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          memcpy(&dest,ptr,4);
    };
    //push the pointer to the next instruction
    //we work here as the process increase the eip before emulating the instruction so the eip now pointing to the next instruction
    thread.stack->push(thread.Eip);
    if (rel){       
       thread.Eip=(dword)((signed int)thread.Eip+(signed int)dest) ;//- s->hde.len+1;
    }else{
          thread.Eip=dest; //we subtract it because the process::emulate  will add it again
    };
};
//=============================================================================================================
//RET
int op_ret(Thread& thread,ins_disasm* s){
    int dest=0;
    //this for the parameters of the function 
    thread.Eip=thread.stack->pop();
    if (s->flags & DEST_IMM){
             thread.Exx[4]+=s->ndest;             
    };
    if (thread.Eip==SEH_MAGIC){                  
       thread.sehReturn();
    };
};
